/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import utilities.TableBook;

public class ResultsBook
extends JFrame {
    private JScrollPane jScrollPane1;
    public int counter;
    String[][][] fixtures;
    Object[][][] tables;
    String name;

    public ResultsBook(Object[][][] standings, String[][][] rounds, int counter, String name) {
        super(name + "Round " + (counter + 1));
        this.tables = standings;
        this.fixtures = rounds;
        this.name = name;
        JFrame frame = new JFrame("Round " + (counter + 1));
        JPanel panel = new JPanel();
        Object[] col = new String[]{"Home Team", "", "", "Away Team"};
        Object[][] data = new Object[rounds[counter].length][4];
        for (int i = 0; i < rounds[counter].length; ++i) {
            data[i][0] = rounds[counter][i][0];
            data[i][1] = rounds[counter][i][1];
            data[i][2] = rounds[counter][i][2];
            data[i][3] = rounds[counter][i][3];
        }
        JTable table = new JTable(data, col);
        this.jScrollPane1 = new JScrollPane();
        JButton selectRound = new JButton();
        JButton tables = new JButton();
        this.jScrollPane1.setViewportView(table);
        this.jScrollPane1.setPreferredSize(new Dimension(400, 800));
        selectRound.setText("Select Matchday");
        tables.setText("Get the Matchday's Tables");
        table.getColumnModel().getColumn(0).setPreferredWidth(200);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 375, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(selectRound).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(tables).addContainerGap(-1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 116, -2)).addGroup(layout.createSequentialGroup().addGap(57, 57, 57).addComponent(selectRound).addComponent(tables)).addGroup(layout.createSequentialGroup())).addContainerGap(173, Short.MAX_VALUE)));
        this.pack();
        ButtonHandler handler = new ButtonHandler();
        selectRound.addActionListener(handler);
        tables.addActionListener(handler);
        frame.add(panel);
    }

    public class ButtonHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            switch (event.getActionCommand()) {
                case "Select Matchday": {
                    String pick = JOptionPane.showInputDialog(null, "Which matchday would you like to view?", "Select Matchday", -1);
                    ResultsBook.this.counter = Integer.parseInt(pick) - 1;
                    ResultsBook.this.dispose();
                    ResultsBook tb = new ResultsBook(ResultsBook.this.tables, ResultsBook.this.fixtures, ResultsBook.this.counter, ResultsBook.this.name);
                    tb.setSize(600, 450);
                    tb.setVisible(true);
                    tb.setDefaultCloseOperation(3);
                    break;
                }
                case "Get the Matchday's Tables": {
                    ResultsBook.this.dispose();
                    TableBook rb = new TableBook(ResultsBook.this.tables, ResultsBook.this.fixtures, ResultsBook.this.counter, ResultsBook.this.name);
                    rb.setSize(600, 450);
                    rb.setVisible(true);
                    rb.setDefaultCloseOperation(3);
                }
            }
        }
    }
}

